%--------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      Simulate3_Selected.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% Description:    This file runs the 3 sensor project based on a selected
%                 set of previous results
%--------------------------------------------------------------------------
close all; clear all; clc;
warning('OFF');

SavePlots = true;
numSensors = 3;

% Note: The previous results must be saved in the file 'Results_3.mat'
% mean3 = 5.5851, 72.1658, 2.9132
% Load in all the data that we are choosing from
load Results_3.mat
deltaE_Idx = 2*numSensors + 1;
MTF50_Idx = 2*numSensors + 2;

FindValues = [  5.561 74.2 ;    % Mean
                5.646 74;       % Mean
                5.638 74.4;     % Mean
                8.323 143.6;    % High Noise
                0.8656 68.8];   % Best color
FindIdx = [];
Tol = 0.0001;

% Make a vactor of distances to test
Dist = sqrt(Results3(:,deltaE_Idx).^2 + Results3(:,MTF50_Idx).^2);

for NumIdx = 1:1:size(FindValues,1),
    Val = sqrt(FindValues(NumIdx,1).^2 + FindValues(NumIdx,2).^2);
    Rows = find(abs(Dist - Val) <= Tol);
    FindIdx = [FindIdx ; Rows];
end

FindIdx
Results3(FindIdx,:)

% Save the names of te parameters that we are changing
sensorSettings_Names = {'Width1','Width2','Width3','Pos1','Pos2','Pos3'};
sensorSettings = Results3(FindIdx,1:6);
save('SensorData3.mat', 'sensorSettings_Names', 'sensorSettings');

NumRows = size(sensorSettings,1);       % Number of different sensors that we're running
colorMetrics = zeros(NumRows,1);        % Initialize vector to save color metrics            
noiseMetrics = zeros(NumRows,1);        % Initialize vector to save noise metrics
frequencyMetrics = zeros(NumRows,1);    % Initialize vector to save frequency metrics

sensorIndex = 1;
analysisIndex = 1;
save('SavedData3.mat','colorMetrics','noiseMetrics','frequencyMetrics','sensorIndex','analysisIndex');

% Loop through all the sensors
Simulate3_Sub;

% Put the results into a matrix that we can save
%--------------------------------------------------------
ResultNames3 = sensorSettings_Names;
Results3 = sensorSettings;

Results3 = [Results3 colorMetrics frequencyMetrics noiseMetrics]; 
ResultNames3 = {ResultNames3{:},'deltaE','MTF50','yNoise'};

% Display the results
disp(ResultNames3);
disp(Results3);

% Save the final results
save('Results_3_Selected.mat', 'ResultNames3', 'Results3');

% Plot the final results
colors = ['r', 'g', 'b', 'y', 'c', 'm', 'k'];
figure(1);
plot(frequencyMetrics, colorMetrics, 'bo','MarkerFaceColor','b');
xlabel('MTF-50');
ylabel('Average \Delta E');
title('\bfColor Accuracy vs Frequency Accuracy, 3 colors');
grid on;
axis([0 max(1.1*frequencyMetrics) 0 max(1.1*colorMetrics)]);

saveas(gcf, ['./Images/Results_3_Selected.eps'],'epsc2');
saveas(gcf, ['./Images/Results_3_Selected.png']);





